import numpy as np


# 定义一个函数来计算马尔科夫边界
def markov_boundary(a):
    nodes = len(a)
    b = np.zeros((nodes, nodes), dtype=int)

    for i in range(nodes):
        # 初始化当前节点的马尔科夫边界
        parents = set()
        children = set()
        spouses = set()

        # 父节点和子节点
        for j in range(nodes):
            if a[i][j] == 1 or (a[i][j] == -1 and a[j][i] == -1):
                children.add(j)
            if a[j][i] == 1 or (a[j][i] == -1 and a[i][j] == -1):
                parents.add(j)

        for p in parents:
            for j in range(nodes):
                if j == i or p == j:
                    continue
                if a[p][j] == 1 or (a[p][j] == -1 and a[j][p] == -1):
                    spouses.add(j)



        # 更新马尔科夫边界
        boundary = parents | children | spouses
        for node in boundary:
            b[i][node] = 1

    return b


a = [
 [0, 1, 1, 1, 0, 1, 0, 1],
 [-1, 0, 1, 0, 0, 1, 1, 0],
 [-1, -1, 0, 0, 1, 0, 0, 1],
 [-1, 0, 0, 0, 0, 0, -1, -1],
 [0, 0, -1, 0, 0, 0, 0, -1],
 [-1, -1, 0, 0, 0, 0, -1, 0],
 [0, -1, 0, 1, 0, 1, 0, 1],
 [-1, 0, -1, 1, 1, 0, -1, 0]
]
Mb = markov_boundary(a)
print(Mb)

